"""
HB_Mirror V1.0

Last Modified: Oct/11/2018
Works with CINEMA 4D R18 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_Mirror
Description-US: Mirror Polygonselection on the Modelling-Axis XZ-Plane [ALT:Use XY-Plane, CTRL: Use ZY-Plane]

Usage:
Make a Polygonselection and enable Axis-Mode (Shortcut L,Tab). Set the Modelling-Axis by clicking on an Edge. Now use the Script to mirror the
selected Polygons on the Modelling-Axis XZ-Plane.
If you click on a Polygon in Axismode the Modelling Axis will get set on the PolygonNormal. In this case use ALT-Modifier to run the Script and mirror on the XY-Plane.


Video Tutorial:



ChangeLog:

Oct/11/2018 V1.0
- Release Version

"""




import c4d
from c4d import utils,gui



def SelectAllPoly(obj):

    polc = obj.GetPolygonCount()
    bs = obj.GetPolygonS()
    for i in range(polc):

        bs.Select(i)

    return





def ConnectAndDelete(ObjA,ObjB):
    ConnectObj=c4d.BaseObject(1011010)
    ConnectObj[c4d.CONNECTOBJECT_TOLERANCE]=0.001
    ConnectObj[c4d.CONNECTOBJECT_PHONG_MODE]=2
    ConnectObj.InsertBefore(ObjA)
    doc.AddUndo(c4d.UNDOTYPE_NEW, ConnectObj)
    ObjA.InsertUnder(ConnectObj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, ObjA)
    ObjB.InsertUnder(ConnectObj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, ObjB)

    CSsettings = c4d.BaseContainer()
    NewObj=utils.SendModelingCommand(command = c4d.MCOMMAND_CURRENTSTATETOOBJECT,
                                    list = [ConnectObj],
                                    mode = c4d.MODELINGCOMMANDMODE_EDGESELECTION,
                                    bc = CSsettings,
                                    doc = doc,
                                    )

    # New Root is a NULL Object
    if NewObj[0].GetType() == c4d.Onull:
        NewPolyObj=NewObj[0].GetDown()
        NewPolyObj.InsertAfter(ConnectObj)
        doc.AddUndo(c4d.UNDOTYPE_NEW, NewPolyObj)
        doc.AddUndo(c4d.UNDOTYPE_DELETE,NewObj[0])
        NewObj[0].Remove()
        doc.AddUndo(c4d.UNDOTYPE_DELETE, ConnectObj)
        ConnectObj.Remove()

        doc.AddUndo(c4d.UNDOTYPE_CHANGE, NewPolyObj )
        NewPolyObj.SetBit(c4d.BIT_ACTIVE)
        NewPolyObj.SetName(name)


    else:
        NewObj[0].InsertAfter(ConnectObj)
        doc.AddUndo(c4d.UNDOTYPE_NEW, NewObj[0])
        doc.AddUndo(c4d.UNDOTYPE_DELETE, ConnectObj)
        ConnectObj.Remove()
        doc.AddUndo(c4d.UNDOTYPE_CHANGE,NewObj[0] )
        NewObj[0].SetBit(c4d.BIT_ACTIVE)
        NewObj[0].SetName(name)



def main():

    global name
    bc = c4d.BaseContainer()
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc)
    
    #if c4d.CallCommand(12156) : print "YES"
    #c4d.SETTINGS_GENERAL
    bcdocsettings= doc.GetData(c4d.DOCUMENTSETTINGS_GENERAL)
    CoordSettings=bcdocsettings.GetBool(c4d.DOCUMENT_STATEW )
    if bcdocsettings.GetBool(c4d.DOCUMENT_STATEW ):
        print "Warning: World Coordinates enabled!!!!"
        #c4d.CallCommand(12156) # Coordinate System

    ALT=False
    SHIFT=False
    CTRL=False
    SHIFTCTRL=False

    if bc[c4d.BFM_INPUT_QUALIFIER] ==1 : SHIFT=True
    if bc[c4d.BFM_INPUT_QUALIFIER] ==2 : CTRL=True
    if bc[c4d.BFM_INPUT_QUALIFIER] ==3 : SHIFTCTRL=True
    if bc[c4d.BFM_INPUT_QUALIFIER] ==4 : ALT=True

    doc.StartUndo()

    selobj=doc.GetActiveObject()
    globalPos=selobj.GetMg()
    name=selobj.GetName()
    newObj= utils.SendModelingCommand(command = c4d.MCOMMAND_SPLIT,
                                list = [selobj],
                                mode = c4d.MODELINGCOMMANDMODE_ALL,
                                bc =  c4d.BaseContainer(),
                                doc = doc,)

    MAxis=selobj.GetModelingAxis(doc)
    symobj= c4d.BaseObject(c4d.Osymmetry)

    doc.AddUndo(c4d.UNDOTYPE_CHANGE,symobj  )
    symobj[c4d.SYMMETRYOBJECT_PLANE]=2
    if ALT:
        symobj[c4d.SYMMETRYOBJECT_PLANE]=0
    if CTRL:
        symobj[c4d.SYMMETRYOBJECT_PLANE]=1

    symobj[c4d.SYMMETRYOBJECT_CLAMPPOINTS]=True
    symobj[c4d.SYMMETRYOBJECT_DELETEPOLYGONS]=True

    symobj.InsertAfter(selobj)
    symobj.SetMg(MAxis)

    doc.AddUndo(c4d.UNDOTYPE_NEW,symobj )
    newObj[0].InsertUnder(symobj)
    doc.AddUndo(c4d.UNDOTYPE_NEW,newObj[0])

    doc.AddUndo(c4d.UNDOTYPE_CHANGE,newObj[0]  )
    newObj[0].SetMg(globalPos)

    symobjConverted=utils.SendModelingCommand(command = c4d.MCOMMAND_CURRENTSTATETOOBJECT,
                                    list = [symobj],
                                    mode = c4d.MODELINGCOMMANDMODE_EDGESELECTION,
                                    bc = c4d.BaseContainer(),
                                    doc = doc
                                        )


    SymPolyobject=symobjConverted[0].GetDown()

    SymPolyobject.InsertAfter(symobj)
    doc.AddUndo(c4d.UNDOTYPE_NEW,SymPolyobject)

    doc.AddUndo(c4d.UNDOTYPE_CHANGE, SymPolyobject )
    SymPolyobject.SetMg(globalPos)


    doc.AddUndo(c4d.UNDOTYPE_DELETE, symobj)
    symobj.Remove()



    doc.AddUndo(c4d.UNDOTYPE_CHANGE, SymPolyobject )
    SymPolyobject.SetBit(c4d.BIT_ACTIVE)

    doc.AddUndo(c4d.UNDOTYPE_CHANGE, selobj )
    selobj.DelBit(c4d.BIT_ACTIVE)


    SelectAllPoly(SymPolyobject)

    ConnectAndDelete(selobj,SymPolyobject)

    doc.EndUndo()



if __name__=='__main__':
    main()
    c4d.EventAdd()



